// Header File
// Created 3/5/2005; 9:55:19 AM


#ifndef _KeyboardUtils
#define _KeyboardUtils

#include "BasicTypes.h"

#define KBD_Repeat   1
#define KBD_NoRepeat 0

typedef enum
{
	KBD_NoKey,
	KBD_Esc, KBD_Enter,
	KBD_Up, KBD_Down, KBD_Left, KBD_Right,
	KBD_UpLeft, KBD_DownLeft, KBD_UpRight, KBD_DownRight,
	KBD_F1, KBD_F2, KBD_F3, KBD_F4, 
	KBD_F5, KBD_F6, KBD_F7, KBD_F8,
	KBD_Home, KBD_Clear, KBD_Backspace, KBD_Space,
	KBD_Apps, KBD_Sto, KBD_Mode, KBD_Catalog,
	KBD_Minus, KBD_Plus, KBD_Multiply, KBD_Divide, 
	KBD_Equals, KBD_Power, KBD_Ln, KBD_EE,
	KBD_Sin, KBD_Cos, KBD_Tan, KBD_Theta, 
	KBD_Or, KBD_Negate,
	KBD_0, KBD_1, KBD_2, KBD_3, KBD_4,
	KBD_5, KBD_6, KBD_7, KBD_8, KBD_9,
	KBD_A, KBD_B, KBD_C, KBD_D, KBD_E,
	KBD_F, KBD_G, KBD_H, KBD_I,	KBD_J, 
	KBD_K, KBD_L, KBD_M, KBD_N, KBD_O, 
	KBD_P, KBD_Q, KBD_R, KBD_S, KBD_T, 
	KBD_U, KBD_V, KBD_W, KBD_X, KBD_Y, KBD_Z,
	KBD_OpenPar, KBD_ClosePar, KBD_Comma, KBD_Period,
	KBD_2nd      = 0x1000,
	KBD_Diamond  = 0x2000,
	KBD_Shift    = 0x4000,
	KBD_Alpha    = 0x8000
} KeyboardInput;


KeyboardInput GetKeyPress(int2 allowRepeat);
KeyboardInput GetFunctionKeyPress(int2 allowRepeat);
KeyboardInput GetDirectionKeyPress(int2 allowRepeat);
KeyboardInput GetModifierKeyPress(int2 allowRepeat);


char* GetCharInput(void);




#endif // _KeyboardUtils